// AlifeView.h : interface of the CAlifeView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ALIFEVIEW_H__517F7AB3_56EA_11D1_8A0D_444553540000__INCLUDED_)
#define AFX_ALIFEVIEW_H__517F7AB3_56EA_11D1_8A0D_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


class CAlifeView : public CView
{
protected: // create from serialization only
	CAlifeView();
	DECLARE_DYNCREATE(CAlifeView)

// Attributes
public:
	CAlifeDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAlifeView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	void resizeFrameWindow(int cx, int cy);
	void viewToDoc(CPoint &pt);
	virtual ~CAlifeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	//Accessors and mutators for params
	Real runspeed(){return GetDocument()->_critterlist->world()->runspeed();}
	void setRunspeed(Real runspeed){GetDocument()->_critterlist->world()->setRunspeed(runspeed);}

protected:
	UINT _fitmode; /*ID_FIT_VARY, ID_FIT_CLIP, or ID_FIT_SQUEEZE are
		three ways to fit the pMemDC into the window.  Respectively they
		resize the Doc _frame, Blt the part of pMemDC that fits into
		the window, StretchBlt the whole pMemDC  to the window. */
	int _stretch_cx, _stretch_cy;
	CRect _stretch_rect;
	void setCursorVector(CPoint point);
	BOOL _bWorldCursor; /* This flag says whether or not you want to drag
		around a world position with your cursor, this affects whether or not
		you are actively moving a CursorCritter */

// Generated message map functions
protected:
	BOOL _resized;
	//{{AFX_MSG(CAlifeView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnFilePause();
	afx_msg void OnUpdateFilePause(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnControlsScore();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnControlsParams();
	//}}AFX_MSG
	/*The following functions are used by handlers corresponding to
a whole range of message values.  These are really macros.  I have to type
them in by hand, I can't add them with Class Wizard.  */
	afx_msg void OnDemo(UINT nID);
	afx_msg void OnDemoUpdate(CCmdUI *pCmdUI);
	afx_msg void OnFit(UINT nID);
	afx_msg void OnFitUpdate(CCmdUI *pCmdUI);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in AlifeView.cpp
inline CAlifeDoc* CAlifeView::GetDocument()
   { return (CAlifeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ALIFEVIEW_H__517F7AB3_56EA_11D1_8A0D_444553540000__INCLUDED_)
